; testmotor.asm
; fait tourner un moteur branch sur PINC5 et PINC4
; pour 2.55 secondes en une direction avec le LED allum
; et pour le mme temps dans l'autre avec le LED teint
; by Nicola Rohrseitz, 2003



.include "8535def.inc"
.include "definitions.asm"
.include "macros.asm"


;interrupt vector table//////////////////////////////////////////////////////////////////
.org	0
	rjmp	reset



;initialization//////////////////////////////////////////////////////////////////////////
reset:
	ldi	r20,2
	ldi	r17,0b00000101		;avancer
	ldi	r18,0b00001010		;reculer
	ldi	r19,0b00000000		;arret
	ldi	r22,0b00000110
	ldi	r16,0xff
	out	DDRB,r16
	out	DDRC,r16
	com	r16
	out	DDRD,r16	
	rjmp	main


;========================================================================================
main:	
	;out	PORTB,r19
	in	r27, PIND		; Lis la valeur du capteur
	sbrs	r27, 0			; Skip if bit in register is set
	rcall	tourne_d
	
	out	PORTC,r17	 	; forward
	wait_ms	25


	rjmp 	main
	
;========================================================================================	

tourne_d:
	ldi	r16,0
	out	PORTB,r16

	out 	PORTC,r18			; recule
	WAIT_MS 150	
	out		PORTC,r22	 		; les 2 moteur tourne dans 2 sens differents
	WAIT_MS 150
	com	r16
	out	PORTB,r16
	ret